unit SrcScannerU;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ExtCtrls, ComCtrls;

const
//bill = 'This is a test' + ' some more ' + ' even more';  <-- original line.  //kt 7/7/2007
  bill = DKLangConstW('SrcScannerU_This_is_a_test') + DKLangConstW('SrcScannerU__some_more_') + DKLangConstW('SrcScannerU__even_more'); //kt added 7/7/2007
  sue = '';

const
  SIGNIF_LEN = 3;

type
  TMainForm = class(TForm)
    Panel1: TPanel;
    Splitter1: TSplitter;
    Panel2: TPanel;
    Panel4: TPanel;
    Panel5: TPanel;
    Panel3: TPanel;
    Panel6: TPanel;
    SaveButton: TBitBtn;
    OpenButton: TBitBtn;
    NextButton: TBitBtn;
    PrevButton: TBitBtn;
    OpenDialog1: TOpenDialog;
    Label1: TLabel;
    Label2: TLabel;
    SaveAsButton: TBitBtn;
    SaveDialog1: TSaveDialog;
    FileNameLabel: TLabel;
    ChangesLabel: TLabel;
    ConstantsButton: TBitBtn;
    BitBtn1: TBitBtn;
    OrigEdit: TMemo;
    NewEdit: TMemo;
    procedure OpenButtonClick(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure SaveButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure NextButtonClick(Sender: TObject);
    procedure PrevButtonClick(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
  private
    { Private declarations }
    FileModuleName : string;
    FName : string;
    dateStr : string;
    FileList: TStringList;
    FileListIndex :integer;
    NewEditText : AnsiString;
    function OpenInputFile(FName : string) : integer;
    function CloseCurFiles : integer;
    procedure ProcessLines;
    function HasSignifStr(s: string) : boolean;
    procedure HandleStrLine(var s:string);
    function DoSave : integer;
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.dfm}

uses StrUtils,ShowConstsU;


procedure TMainForm.OpenButtonClick(Sender: TObject);
begin
  dateStr := DateToStr(Date);
  if OpenDialog1.Execute then begin
    FileList.Assign(OpenDialog1.Files);
    FileListIndex:=-1;
    NextButtonClick(nil);
  end;
end;

procedure TMainForm.NextButtonClick(Sender: TObject);
var Result : integer;
begin
  FileListIndex:=FileListIndex+1;
  if FileListIndex<FileList.Count then begin
    FName := FileList.Strings[FileListIndex];
    Result := OpenInputFile(FName);
    if Result = mrCancel then FileListIndex:=FileListIndex-1;
  end else begin
    FileListIndex:=FileListIndex-1;
//  MessageDlg('No "Next" file to select.', mtError, [mbOK], 0);  <-- original line.  //kt 7/7/2007
    MessageDlg(DKLangConstW('SrcScannerU_No_"Next"_file_to_select.'), mtError, [mbOK], 0); //kt added 7/7/2007
  end;
end;


procedure TMainForm.PrevButtonClick(Sender: TObject);
var Result : integer;
begin
  FileListIndex:=FileListIndex-1;
  if FileListIndex>-1 then begin
    FName := FileList.Strings[FileListIndex];
    Result := OpenInputFile(FName);
    if Result = mrCancel then FileListIndex:=FileListIndex+1;
  end else begin
    FileListIndex:=FileListIndex+1;
//  MessageDlg('No "Previous" file to select.', mtError, [mbOK], 0);  <-- original line.  //kt 7/7/2007
    MessageDlg(DKLangConstW('SrcScannerU_No_"Previous"_file_to_select.'), mtError, [mbOK], 0); //kt added 7/7/2007
  end;
end;

function TMainForm.OpenInputFile(FName : string) : integer;
var BakFName : string;
begin
  Result := CloseCurFiles;
  if result <> mrCancel then begin
    FileNameLabel.Caption:= ExtractFileName(FName);
//  FileModuleName := AnsiReplaceStr(FileNameLabel.Caption, '.pas', '');  <-- original line.  //kt 7/7/2007
    FileModuleName := AnsiReplaceStr(FileNameLabel.Caption, DKLangConstW('SrcScannerU_.pas'), ''); //kt added 7/7/2007
    FileModuleName := AnsiReplaceStr(FileModuleName, ' ', '_');

    OrigEdit.Lines.LoadFromFile(FName);  //does a clear first
//  BakFName:=FName + '.bak';  <-- original line.  //kt 7/7/2007
    BakFName:=FName + DKLangConstW('SrcScannerU_.bak'); //kt added 7/7/2007
    OrigEdit.Lines.SaveToFile(BakFName);  //make an immediate copy
    ProcessLines;
  end;  
end;

function TMainForm.CloseCurFiles : integer;
begin
  //check if should be saved.
  Result := DoSave;
  if Result <> mrCancel then begin
    NewEdit.Lines.Clear;
  end;  
end;

procedure TMainForm.ProcessLines;
var i,j : integer;
    tempS,s : string;
begin
  for i:=0 to OrigEdit.Lines.Count-1 do begin
    s := OrigEdit.Lines.Strings[i];
    if HasSignifStr(s) then begin
      tempS := s;
      HandleStrLine(s);
      if tempS<>s then begin
        for j:=1 to 2 do if MidStr(tempS,1,1)=' ' then tempS:=MidStr(tempS,2,999);
        tempS := '//'+tempS+ '  <-- original line.  //kt '+ dateStr;
        NewEdit.Lines.Add(tempS);
      end
    end;
    NewEdit.Lines.Add(s);
  end;
end;

function TMainForm.HasSignifStr(s: string) : boolean;
var p1,p2 : integer;

begin
  Result := false;
  s := AnsiReplaceStr(s, '''''', '');
  //screen for "//" style comments
  if Pos('//',s)>0 then begin
    p1 := Pos('//',s);
    s := MidStr(s,1,p1-1);
  end;
  p1 := 0;
  repeat
    p1 := PosEx('''',s,p1+1);
    if (p1>0) and ((midstr(s,p1,2)<>'\"')) then begin
      p2 := PosEx('''',s,p1+1);
      if (p2-p1-1)>=SIGNIF_LEN then Result:= true;
      p1:=p2;
    end;
  until (p1=0) or (Result=true);
end;


procedure TMainForm.HandleStrLine(var s:string);
var
    origS, tempS,
    constStr,constSName: string;
    p1,p2:integer;
begin
  origS:=s;
  while AnsiReplaceStr(s, '''''', '') <> s do begin
    s := AnsiReplaceStr(s, '''''', '\"');  // convert '' --> \"
  end;

  p1 := 0;
  repeat
    p1 := PosEx('''',s,p1+1);
    if (p1>0) and ((midstr(s,p1,2)<>'\"')) then begin
      p2 := PosEx('''',s,p1+1);
      if (p2-p1-1)>=SIGNIF_LEN then begin
        constStr := AnsiMidStr(s, p1+1, (p2-p1-1));
        //create dkLang constant name
        constSName := FileModuleName+'_'+AnsiReplaceStr(constStr, ' ', '_');
        ConstantsOutputForm.AddConst(constSName,constStr);
//      tempS := AnsiMidStr(s, 1, p1-1)+ 'DKLangConstW(''' + constSName + ''')';  <-- original line.  //kt 7/7/2007
        tempS := AnsiMidStr(s, 1, p1-1)+ DKLangConstW('SrcScannerU_DKLangConstW(''') + constSName + ''')'; //kt added 7/7/2007
        s := tempS + AnsiMidStr(s, p2+1, 999);
        p1 := length(tempS)+1;
      end else p1:=p2+1
    end;
  until (p1=0);

  s := AnsiReplaceStr(s, '\"', '''''');  // convert '\"' --> ''
  s := s+ ' //kt added ' +dateStr;
end;

procedure TMainForm.SpeedButton1Click(Sender: TObject);
begin
  ConstantsOutputForm.Show;
end;

procedure TMainForm.SaveButtonClick(Sender: TObject);
begin
  DoSave;
end;

function TMainForm.DoSave : integer;
begin
  Result := mrYes;
  if (NewEdit.Lines.Count>0) and (NewEdit.Lines.Text<>NewEditText) then begin
//  Result := MessageDlg('Overwrite existing source code?',mtConfirmation, [mbYes, mbNo, mbCancel],0);  <-- original line.  //kt 7/7/2007
    Result := MessageDlg(DKLangConstW('SrcScannerU_Overwrite_existing_source_code?'),mtConfirmation, [mbYes, mbNo, mbCancel],0); //kt added 7/7/2007
    if Result = mrYes then begin
      NewEdit.Lines.SaveToFile(FName);
      NewEditText:=NewEdit.Lines.Text;
    end;
  end else begin
    //MessageDlg('Nothing to save!', mtInformation, [mbOK], 0);
  end;
end;


procedure TMainForm.FormCreate(Sender: TObject);
begin
  FileList := TStringList.Create;
end;

procedure TMainForm.FormDestroy(Sender: TObject);
begin
  FileList.Free;
end;


procedure TMainForm.BitBtn1Click(Sender: TObject);
begin
  if ConstantsOutputForm.NeedsSave then begin
//  if MessageDlg('Save Gathered Constants List (Important)?',  <-- original line.  //kt 7/7/2007
    if MessageDlg(DKLangConstW('SrcScannerU_Save_Gathered_Constants_List_(Important)?'), //kt added 7/7/2007
      mtConfirmation, [mbYes, mbNo], 0) = mrYes then begin
      ConstantsOutputForm.SaveButtonClick(nil);
    end;
  end;
  Application.Terminate;
end;

end.
